<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <link rel="icon" href="data:,">
  <title>Police CAD</title>
  <style>
    body {
      font-family: Arial, sans-serif;
      margin: 0;
      background-color: #d9d9d9;
      color: black;
    }

    header {
      display: flex;
      justify-content: space-between;
      align-items: center;
      padding: 10px 20px;
      background-color: #a0a0a0;
      border-bottom: 2px solid #999;
    }

    #nzClock {
      font-size: 1rem;
      font-weight: bold;
    }

    .main {
      display: flex;
      height: calc(100vh - 60px);
    }

    .left-panel, .right-panel {
      flex: 1;
      padding: 10px;
      overflow-y: auto;
    }

    .left-panel {
      display: flex;
      flex-direction: column;
      border-right: 2px solid #999;
    }

    .call-entry {
      flex: 1;
      margin-bottom: 10px;
      background-color: #efefef;
      padding: 10px;
      display: flex;
      flex-direction: column;
      gap: 5px;
    }

    .call-entry input,
    .call-entry textarea {
      padding: 5px;
      font-size: 14px;
      border: 1px solid #999;
      background-color: white;
    }

    .note-list {
      list-style: none;
      padding: 0;
      margin: 5px 0;
    }

    .note-list li {
      background: white;
      padding: 4px 8px;
      margin-bottom: 4px;
      border: 1px solid #ccc;
      display: flex;
      justify-content: space-between;
      align-items: center;
    }

    .note-list button {
      margin-left: 10px;
      background: #c00;
      color: white;
      border: none;
      padding: 2px 6px;
      cursor: pointer;
    }

    .event-list {
      flex: 1;
    }

    h2 {
      margin: 5px 0;
      font-size: 1rem;
    }

    .controls {
      margin: 5px 0;
      display: flex;
      gap: 5px;
    }

    button {
      background-color: #666;
      color: white;
      border: none;
      padding: 5px 10px;
      cursor: pointer;
    }

    button:hover {
      background-color: #888;
    }

    table {
      width: 100%;
      border-collapse: collapse;
      background-color: #efefef;
    }

    th, td {
      border: 1px solid #ccc;
      padding: 4px 6px;
      text-align: left;
      font-size: 12px;
    }

    th {
      background-color: #ccc;
    }

    .right-panel {
  flex: 1;
  background: #e6e6e6;
  padding: 10px;
  display: flex;
  flex-direction: column;
}

.unit-header-row {
  display: grid;
  grid-template-columns: 1fr 1fr 1fr 2fr 1fr;
  font-weight: bold;
  background: #ccc;
  padding: 5px;
  border-bottom: 2px solid #999;
}

.unit-scroll-list {
  overflow-y: auto;
  flex: 1;
}

.unit-item {
  display: grid;
  grid-template-columns: 1fr 1fr 1fr 2fr 1fr;
  align-items: center;
  padding: 6px;
  border-bottom: 1px solid #aaa;

}

table {
  border-spacing: 0 6px; 
  border-collapse: separate;
}

.unit-entry-form {
  display: grid;
  grid-template-columns: 1fr 1fr 1fr 2fr auto;
  gap: 5px;
  padding: 10px 0;
}

.unit-entry-form input,
.unit-entry-form select {
  padding: 4px;
  font-size: 12px;
  width: 100%;
  box-sizing: border-box;
}

.unit-entry-form button {
  padding: 4px 10px;
  font-size: 12px;
  background-color: #666;
  color: white;
  border: none;
  cursor: pointer;
}

.unit-entry-form button:hover {
  background-color: #888;
}

#statusBox {
  position: absolute;
  background: white;
  border: 2px solid #999;
  border-radius: 6px;
  box-shadow: 0 4px 8px rgba(0,0,0,0.1);
  padding: 8px;
  display: none;
  z-index: 1000;
  font-family: sans-serif;
}

#statusBox .status-action {
  padding: 6px 12px;
  margin: 4px 0;
  text-align: center;
  font-weight: bold;
  border-radius: 4px;
  cursor: pointer;
  transition: background 0.2s ease;
}


.status-action.assign {
  background-color: #f8bcbc;
  color: #a00;
}
.status-action.status-10-2 {
  background-color: #c8f7c5;
  color: #095c09;
}
.status-action.status-10-7 {
  background-color: #2a7f2a; 
  color: white;
}
.status-action.clear {
  background-color: #d0eaff; 
  color: #004080;
}

.unit-item {
  margin: 8px;
  padding: 10px;
  border-radius: 5px;
}

.unit-item.selected {
  outline: 4px solid black;
  outline-offset: 1.5px;
}

.status-action:hover {
  opacity: 0.9;
}

#noteList {
  max-height: 200px; 
  overflow-y: auto;
  padding-right: 5px; 
}

#noteList {
  max-height: 200px;
  overflow-y: auto;
  padding-right: 5px;
  border: 1px solid #ccc;
  background-color: #f9f9f9;
}

.unit-item .locked {
  font-size: 10px;
  color: #f00;
  margin-top: 4px;
  font-style: italic;
}

.popup {
  position: fixed;
  top: 30%;
  left: 40%;
  background: white;
  padding: 20px;
  border: 2px solid #333;
  border-radius: 8px;
  z-index: 1000;
  box-shadow: 0 0 10px rgba(0,0,0,0.3);
}
.hidden {
  display: none;
}

    .status-10-2 { background-color: lightgreen; color: black; }
    .status-10-3 { background-color: lightblue; color: black; }
    .status-10-7 { background-color: darkgreen; color: white; }
    .status-10-0 { background-color: grey; color: white; }
    .status-10-5 { background-color: red; color: white; }
  </style>
</head>

<BODY>
  <header>
    <h1>POLICE CAD SYSTEM</h1>
    <div id="nzClock">NZ Time: --:--:--</div>
    <button id="priorityToggle" style="position: fixed; top: 10px; right: 10px; z-index: 1000;">
     Enable Priority Mode
    </button>
  </header>

  <div class="main">
    <div class="left-panel">
      <div class="call-entry">
        <input type="text" id="locationInput" placeholder="Location">
        <input type="text" id="codeInput" placeholder="Code">
        <input type="text" id="priorityInput" placeholder="Priority">
        <input type="text" id="evNumberInput" placeholder="Event Number is auto-assigned" readonly>


        <textarea id="noteInput" rows="2" placeholder="Add new note..."></textarea>
        <button id="addNoteBtn">Add Note</button>
        <ul id="noteList" class="note-list"></ul>

        <div class="controls">
          <button id="saveChangesBtn">SAVE CHANGES</button>
          <button id="cancelChangesBtn">CANCEL</button>
          <button id="addEventBtn">NEW EVENT</button>
          <button id="closeJobBtn" class="action-button">CLOSE JOB</button>
          <div id="closeJobPopup" class="popup hidden">
  <h3>Close Job</h3>
  <label for="kCodeSelect">Job Result (K-code):</label>
  <select id="kCodeSelect">
    <option value="K1">K1 – Left with no further action</option>
    <option value="K6">K6 – Reported</option>
    <option value="K7">K7 – Left for expert</option>
    <option value="K8">K8 – Left for prime unit</option>
    <option value="K9">K9 – Arrest made</option>
  </select>
  <br><br>
  <button id="confirmCloseJob">Confirm Close</button>
  <button id="cancelCloseJob">Cancel</button>
</div>
        </div>
      </div>

      <div class="event-list">
        <h2>Active Events</h2>
        <table class="event-table">
          <thead>
            <tr>
              <th>PRIORITY</th>
              <th>CODE</th>
              <th>EV NUMBER</th>
              <th>LOCATION</th>
            </tr>
          </thead>
          <tbody></tbody>
        </table>
      </div>
    </div>

    <div class="right-panel">
      <div class="unit-entry-form">
        <input type="text" id="unit-callsign" placeholder="Callsign" />
        <select id="unit-status">
          <option value="10-2">10/2</option>
          <option value="10-3">10/3</option>
          <option value="10-7">10/7</option>
          <option value="10-0">10/0</option>
          <option value="10-5">10/5</option>
        </select>
        <input type="text" id="unit-evnum" placeholder="EV Number" />
        <input type="text" id="unit-location" placeholder="Location" />
        <button onclick="addUnit()">Add Unit</button>
      </div>
    
      <div class="unit-header-row">
        <div>CALLSIGN</div>
        <div>STATUS</div>
        <div>EV NUMBER</div>
        <div>LOCATION</div>
        <div>CLOSE REQ</div>
      </div>
      <div id="unitList" class="unit-scroll-list"></div>
    </div>

    <div id="statusBox" class="status-box">
      <div class="status-action assign" onclick="changeSelectedStatus('ASSIGN')">ASSIGN</div>
      <div class="status-action status-10-2" onclick="changeSelectedStatus('10-2')">STATUS 10/2</div>
      <div class="status-action status-10-7" onclick="changeSelectedStatus('10-7')">STATUS 10/7</div>
      <div class="status-action clear" onclick="changeSelectedStatus('CLEAR')">CLEAR UNIT</div>
    </div>
    

  <script src="script.js"></script>
</body>
</html>