<?php
require_once 'db.php';
header('Content-Type: application/json');

try {
    $priority = $_POST['priority'] ?? '';
    $code     = $_POST['code'] ?? '';
    $location = $_POST['location'] ?? '';

    if (!$priority || !$code || !$location) {
        throw new Exception("Missing required fields");
    }

    $stmt = $pdo->prepare("
        INSERT INTO events (ev_number, priority, code, location)
        VALUES (
            (SELECT IFNULL(MAX(ev_number), 1000) + 1 FROM events),
            :priority, :code, :location
        )
    ");

    $stmt->execute([
        ':priority' => $priority,
        ':code'     => $code,
        ':location' => $location
    ]);

    echo json_encode([
        "success" => true,
        "event_id" => $pdo->lastInsertId()
    ]);
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        "success" => false,
        "error" => $e->getMessage()
    ]);
}