<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);
include '../db.php';

header("Content-Type: application/json");

$data = json_decode(file_get_contents("php://input"), true);
$evNumber = $data['evNumber'] ?? '';
$note = $data['note'] ?? '';

if (!$evNumber || !$note) {
  echo json_encode(['success' => false, 'error' => 'Missing data']);
  exit;
}

// Fetch existing notes for the event
$stmt = $pdo->prepare("SELECT notes FROM events WHERE evNumber = ?");
$stmt->execute([$evNumber]);
$row = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$row) {
  echo json_encode(['success' => false, 'error' => 'Event not found']);
  exit;
}

$notes = json_decode($row['notes'], true);
if (!is_array($notes)) $notes = [];

array_unshift($notes, $note);  // prepend new note

// Save back to DB
$newNotes = json_encode($notes);

$update = $pdo->prepare("UPDATE events SET notes = ? WHERE evNumber = ?");
$update->execute([$newNotes, $evNumber]);

echo json_encode(['success' => true, 'notes' => $notes]);
?>
