<?php
require_once 'db.php';
header('Content-Type: application/json');

try {
    $event_id = $_POST['event_id'] ?? null;
    $unit_id  = $_POST['unit_id'] ?? null;
    $status   = $_POST['status'] ?? '10-5';

    if (!$event_id || !$unit_id) {
        throw new Exception("Missing parameters");
    }

    // Link unit to event
    $stmt = $pdo->prepare("
        INSERT IGNORE INTO event_units (event_id, unit_id)
        VALUES (:event_id, :unit_id)
    ");
    $stmt->execute([
        ':event_id' => $event_id,
        ':unit_id'  => $unit_id
    ]);

    // Update unit state
    $stmt = $pdo->prepare("
        UPDATE units
        SET current_event_id = :event_id, status = :status
        WHERE id = :unit_id
    ");
    $stmt->execute([
        ':event_id' => $event_id,
        ':status'   => $status,
        ':unit_id'  => $unit_id
    ]);

    echo json_encode(["success" => true]);
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        "success" => false,
        "error" => $e->getMessage()
    ]);
}