<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

include '../db.php'; // This defines $pdo

$data = json_decode(file_get_contents("php://input"), true);
$evNumber = $data['evNumber'] ?? '';

// Confirm database connection
if (!isset($pdo) || !$pdo) {
    echo json_encode(['success' => false, 'error' => 'Database connection not established']);
    exit;
}

if (!$evNumber) {
    echo json_encode(['success' => false, 'error' => 'Missing event number']);
    exit;
}

try {
    $delete = $pdo->prepare("DELETE FROM events WHERE evNumber = ?");
    $delete->execute([$evNumber]);

    echo json_encode(['success' => true]);
} catch (PDOException $e) {
    echo json_encode(['success' => false, 'error' => 'SQL Error: ' . $e->getMessage()]);
}
?>